#!/bin/bash

CLIENT_ID="<ENTER_YOUR_MIX_CLIENT_ID_HERE>"
SECRET="<ENTER_YOUR_MIX_CLIENT_SECRET_HERE>"

# URL encode the client id by converting ':' characters to '%3A'
CLIENT_ID=${CLIENT_ID//:/%3A}

AUTHURL="https://auth.crt.nuance.com/oauth2/token"

# Acquire token from server, extract token string from the json response.
export TOKEN="$(curl -s -u "$CLIENT_ID:$SECRET" "$AUTHURL" \
  -d "grant_type=client_credentials" \
  -d "scope=nr" \
  | python -c 'import sys, json; print(json.load(sys.stdin)["access_token"])'
  )"

# Run the client. Pass the token and DTMF sequence to recognize as command line arguments.
./nr-dtmf-client.py nr.api.nuance.com:443 $TOKEN $1
