#!/bin/bash


echo "Setting CLIENT_ID and SECRET"

export CLIENT_ID="ENTER YOUR MIX CLIENT ID HERE"
export SECRET="ENTER YOUR MIX CLIENT SECRET HERE"

echo "CLIENT_ID: " $CLIENT_ID
echo ""
echo "URL encoding CLIENT_ID"
# URL encode the client id by converting ':' characters to '%3A'
CLIENT_ID=${CLIENT_ID//:/%3A}
echo ""
echo "Updated CLIENT_ID: "$CLIENT_ID
echo ""
#'?' matches any character and '//' tells bash to replace all matches to the asterisk
echo "SECRET: "${SECRET//?/*}
echo ""

export TOKEN="`curl -s -u "$CLIENT_ID:$SECRET" "https://auth.crt.nuance.com/oauth2/token" \
-d "grant_type=client_credentials" -d "scope=nlu asr" \
| python -c 'import sys, json; print(json.load(sys.stdin)["access_token"])'`"

python3 nlu_client.py --serverUrl "nlu.api.nuance.com" \
    --token $TOKEN \
    --modelUrn "$1" \
    --textInput "$2" \
    --wordsetUrn "$3"