#!/bin/bash 

CLIENT_ID=<Mix client ID, starting with appID:>
SECRET=<Mix secret>
# URL encode the client id by converting ':' characters to '%3A'
CLIENT_ID=${CLIENT_ID//:/%3A}

MY_TOKEN="`curl -s -u "$CLIENT_ID:$SECRET" "https://auth.crt.nuance.com/oauth2/token" \
-d "grant_type=client_credentials" -d "scope=dlg" \
| python -c 'import sys, json; print(json.load(sys.stdin)["access_token"])'`"

# Scenario 1: Text input and output
python3 dlg_client.py --serverUrl dlg.api.nuance.com \
    --token $MY_TOKEN \
    --secure \
    --modelUrn $1 \
    --textInput "$2" 

# Scenario 2: Text input and TTS output
#python3 dlg_client.py --serverUrl dlg.api.nuance.com \
#   --token $MY_TOKEN \
#   --secure \
#   --tts \
#   --modelUrn $1 \
#   --textInput "$2" 

# Scenario 3: Audio input and TTS output
#python3 dlg_client.py --serverUrl dlg.api.nuance.com \
#    --token $MY_TOKEN \
#    --secure \
#    --tts \
#    --audioFile OrderCoffee_i_want_a_double_espresso.wav \
#    --modelUrn $1 
