#!/bin/bash 

CLIENT_ID=<Mix client ID, starting with appID:>
SECRET=<Mix secret>
# URL encode the client id by converting ':' characters to '%3A'
CLIENT_ID=${CLIENT_ID//:/%3A}

# Scenario 1: Text input and output
python3 dlg_client.py --oauthURL https://auth.crt.nuance.com/oauth2/token \
   --clientID $CLIENT_ID --clientSecret $SECRET \
   --serverUrl dlg.api.nuance.com \
   --secure \
   --modelUrn $1 \
   --textInput "$2" 

# Scenario 2: Text input and TTS output
#python3 dlg_client.py --oauthURL https://auth.crt.nuance.com/oauth2/token \
#   --clientID $CLIENT_ID --clientSecret $SECRET \
#   --serverUrl dlg.api.nuance.com \
#   --secure \
#   --tts \
#   --modelUrn $1 \
#   --textInput "$2" 

# Scenario 3: Audio input and TTS output
#python3 dlg_client.py --oauthURL https://auth.crt.nuance.com/oauth2/token \
#   --clientID $CLIENT_ID --clientSecret $SECRET \
#   --serverUrl dlg.api.nuance.com \
#   --secure \
#   --tts \
#   --audioFile OrderCoffee_i_want_a_double_espresso.wav \
#   --modelUrn $1 