import logging, datetime, functools
from collections import namedtuple

LoggerArgs = namedtuple('LoggerArgs', ('json', 'quiet', 'loglevel', 'logfile'))
defaultLoggerArgs = LoggerArgs(False, False, 'info', None)

def configure_logging(log=logging.getLogger('nqgcli'), args=defaultLoggerArgs, delayed_open=False, **kwargs):
    logging.addLevelName(50, "FATAL")
    if 'format' not in kwargs:
        kwargs['format'] = "%(asctime)s %(levelname)-5s: %(message)s"
    if 'level' not in kwargs:
        kwargs['level'] = logging.getLevelName(args.loglevel.upper())
    log.setLevel(kwargs['level'])
    log.propagate = False
    if not args.quiet:
        sh = logging.StreamHandler()
        sh.setFormatter(logging.Formatter(kwargs['format']))
        log.addHandler(sh)
    def generate_log_file_name():
        return "nqgcli-{}.log".format(datetime.now().strftime("%Y%m%d-%H%M%S"))
    
    if args.logfile:
        logfile = args.logfile if type(args.logfile) is str else generate_log_file_name()
        fh = logging.FileHandler(logfile, mode="w", delay=delayed_open)
        fh.setFormatter(logging.Formatter(kwargs['format']))
        log.addHandler(fh)

